;/*************************************************
; Program		:Speaker
; Description	:Make sound by speaker,the speaker can mount to any port pin 
;				:butin CP-AVR V4.0 board, it connected to PB7.
; CPU Control	:ATmega163
; File name		:speaker.asm
; Assembler		:AVR Studio 4.05
;**************************************************

.include "m163def.inc" 			

			.org   	$000 
    		rjmp  reset				;Reset Handle
;/************************
; Define Register
;/************************
.def		counter1  	= r16
.def		counter2	= r17
.def		counter3	= r18
.def		temp		= r19
.def		temp1		= r20
;/***********************
; Define I/O Port,Pin
;/***********************
.equ		SPK		= 128				;bit 7
;/*******************
; Main Program
;/*******************
reset:		ldi	temp,low(ramend)
			out	SPL,temp
			ldi	temp,high(ramend)
			out	SPH,temp
			ser	temp
			out	DDRB,temp
			ldi	counter3,0
sound:		rcall	Read_Pin
			sbr	temp,SPK
			out	PORTB,temp
			rcall	delay
			rcall	Read_Pin
			cbr	temp,SPK
			out	PORTB,temp
			rcall	delay
			dec	counter3
			brne	sound
			rcall	delay500ms
			rjmp	sound		

;/**************************************************
; Read data from PORT_KBI. This routime is
; not importance if has only a speaker on PORTB
;/**************************************************
read_pin:	clr	temp1
			out	DDRB,temp1		;clear PORTB as input
			in	temp,PINB		;read pin
			ser	temp1
			out	DDRB,temp1
			ret

;/*****************
; delay time
;/*****************
delay:   	push	counter2
			ldi    	counter2,255
delay1:   	nop
			nop
			dec    	counter2
            brne   	delay1
			pop	counter2
            ret          

delay30ms:	ldi    	counter1,240
delay30ms_1:   	
			ldi    	counter2,250
delay30ms_2:   	
			nop
			dec    	counter2
            brne   	delay30ms_2
            dec    	counter1
            brne   	delay30ms_1
			ret          

delay500ms:	push	counter3
			ldi	counter3,16
delay500ms_1:	
			rcall	delay30ms
			dec	counter3
			brne	delay500ms_1
			pop	counter3
			ret
           	 